clear all

capture log close
log using create_dataset.smcl, replace

* Coverscreen
use "$root/Wave 1/sharew1_rel6-0-0_cv_r", clear
sort mergeid
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_cv_r"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_cv_r"
drop if deceased==1
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_cv_r"
drop if deceased==1
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_cv_r"
drop if deceased==1
recode wave .=6
sharetom5 _all, replace

tab wave

/*
label define country_ 11 "Austria" 12 "Germany" 13 "Sweden" ///
14 "Netherlands" 15 "Spain" 16 "Italy" 17 "France" ///
18 "Denmark" 19 "Greece" 20 "Switzerland" 23 "Belgium" 25 "Israel" 28 "Czechia" ///
29 "Poland" 30 "Ireland" 31 "Luxemburg" 32 "Hungary" 33 "Portugal" 34 "Slovenia" 35 "Estonia"
label value country country_
*/

g hhid_current=hhid1 if wave==1
replace hhid_current=hhid2 if wave==2
replace hhid_current=hhid4 if wave==4
replace hhid_current=hhid5 if wave==5
replace hhid_current=hhid6 if wave==6
drop hhid1 hhid2 hhid4 hhid5 hhid6

g mergeidp=mergeidp1 if wave==1
replace mergeidp=mergeidp2 if wave==2
replace mergeidp=mergeidp4 if wave==4
replace mergeidp=mergeidp5 if wave==5
replace mergeidp=mergeidp6 if wave==6
drop mergeidp1 mergeidp2 mergeidp4 mergeidp5 mergeidp6

g x=1
egen totx=sum(x), by(mergeid wave)
tab totx
drop x totx

sort country wave mergeid
save cover, replace

* check non responding partner
use cover, clear
keep wave mergeidp interview
ren mergeidp mergeid
ren interview interviewp
keep if mergeid!=""
sort wave mergeid
save canc, replace

use cover, clear
sort wave mergeid
merge 1:1 wave mergeid using canc
tab interviewp
drop _merge
g dm_partner=mergeidp!=""
sort wave mergeid
save cover, replace

*************************************************************************************************	
use "$root/Wave 1/sharew1_rel6-0-0_gv_weights", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_gv_weights"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_gv_weights"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_gv_weights"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_gv_weights"
recode wave .=6

g weight_ind=cciw_w1 if wave==1
replace weight_ind=cciw_w2 if wave==2
replace weight_ind=cciw_w4 if wave==4	
replace weight_ind=cciw_w5 if wave==5	
replace weight_ind=cciw_w6 if wave==6	
label var weight_ind "calibrated cross-sectional individual weights"

g weight_hh=cchw_w1 if wave==1
replace weight_hh=cchw_w2 if wave==2
replace weight_hh=cchw_w4 if wave==4	
replace weight_hh=cchw_w5 if wave==5	
replace weight_hh=cchw_w6 if wave==6	
label var weight_ind "Calibrated cross-sectional household weight"

g weight_sampl=dw_w1 if wave==1
replace weight_sampl=dw_w2 if wave==2
replace weight_sampl=dw_w4 if wave==4	
replace weight_sampl=dw_w5 if wave==5	
replace weight_sampl=dw_w6 if wave==6	
label var weight_ind "Design weight"

keep country wave mergeid weight_ind weight_hh weight_sampl
sort country mergeid wave
save weights, replace

*************************************************************************************************	
* EXPECTATION SECTION
use "$root/Wave 1/sharew1_rel6-0-0_ex", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_ex"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_ex"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_ex"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_ex"
recode wave .=6
sharetom5 _all, replace
tab wave

ren ex001_ ex_sunny
label var ex_sunny "chances tomorrow sunny"
ren ex002_ ex_inherit
label var ex_inherit "chances receiving inheritance"
ren ex003_ ex_inherit50K
label var ex_inherit50K "chances inherit >50K"
ren ex004_ ex_leave50K
label var ex_leave50K "chances leave inheritance >50K"
ren ex005_ ex_leaveany
label var ex_leaveany "chances leave any inheritance"
ren ex006_ ex_leave150K
label var ex_leave150K "chances leave inheritance >150K"
ren ex007_ ex_gov_red_pen
label var ex_gov_red_pen "chances government reduces pension before s/he retires"
ren ex008_ ex_gov_age_incr
label var ex_gov_age_incr "chances government raises retirement age before s/he retires"
ren ex025_ ex_gov_age_63
label var ex_gov_age_63 "chances s/he will be working full time after s/he reaches age 63"		
ren ex009_ ex_expectancy
label var ex_expectancy "Chances alive in 10 years"
ren ex009age ex_expectancy_age
label var ex_expectancy_age "Age for the question on life expectancy"
ren ex010_ ex_better
label var ex_better "Chances standard of living better in 5 years"
ren ex011_ ex_worse
label var ex_worse "Chances standard of living worse in 5 years"
ren ex110_ ex_risk_av 
label var ex_risk_av "Risk aversion"

tab ex109_ wave, miss
ren ex109_ internet_4

keep ex_gov_red_pen ex_gov_age_incr ex_gov_age_63 ex_expectancy ex_sunny ex_inherit ex_inherit50K ex_leave50K ///
ex_leaveany ex_leave150K ex_expectancy_age ex_better ex_worse ex_risk_av internet_4 country wave mergeid 
sort country wave mergeid
save expectations, replace


use "$root/Wave 2/sharew2_rel6-0-0_as", clear
g wave=2
sharetom5 _all, replace
ren as068_ as_risk_av
keep country wave mergeid as_risk_av
sort country wave mergeid
merge 1:1 country wave mergeid using expectations
tab _merge if wave==2
drop _merge
replace ex_risk_av= as_risk_av if wave==2
drop as_risk_av
sort country wave mergeid
save expectations, replace

*************************************************************************************************	
* DEMOGRAPHIC SECTION

* Age and register
use cover, clear

drop if interview==0

ren gender dm_gender
tab dm_gender wave, miss
* No missing for gender

tab yrbirth wave, miss
tab mobirth wave, miss
* There are some refusals, in particular for month of birth
* There are also some missing for which is not clear the origin; e-mail share team

g dm_age_years=age_int

* I add household size
ren hhsize dm_hsize

keep country wave mergeid dm_gender dm_age_years dm_hsize dm_partner int_year int_month
sort country mergeid
save age, replace

* Education: only once for each individual in the longitudinal sample
* The educational level is asked only for non-longitudinal individuals.
* We can recover it from previous years

* ATTENTION: WAVE 5 and 6 HAVE TWO ISCED. WE NEED THE 1997 VERSION
use  "$root/Wave 5/sharew5_rel6-0-0_gv_isced", clear
g wave=5
keep country wave mergeid isced1997_r
save eduwave5, replace

use  "$root/Wave 6/sharew6_rel6-0-0_gv_isced", clear
g wave=6
keep country wave mergeid isced1997_r
save eduwave6, replace

use "$root/Wave 1/sharew1_rel6-0-0_gv_isced", clear
keep country mergeid isced1997_r
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_gv_isced"
keep country wave mergeid isced1997_r
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_gv_isced"
keep country wave mergeid isced1997_r
recode wave .=4
append using eduwave5
append using eduwave6

ren isced1997_r isced_r

sharetom5 _all, replace
sort mergeid wave

egen minwave=min(wave), by(country mergeid)
g xx=1
egen tot_waves=sum(xx), by(country mergeid)
drop xx

* For longitudinal individuals, the isced should have been reported only once
* in the first wave in which they are interviewd

* In some case it is not reported in some waves
g x=(isced_r!=. & isced_r!=.a & isced_r!=.b)
egen tx=sum(x), by(country mergeid)
tab tx tot_waves
* In some others it changed
sort mergeid wave
g z=(isced_r!=isced_r[_n+1] & mergeid==mergeid[_n+1]) 
egen totz=sum(z), by(country mergeid)
tab z
tab totz

* They are overall few cases
* (1) I get back the value in case the first wave was missing
sort mergeid wave
replace isced_r=isced_r[_n+1] if mergeid==mergeid[_n+1] & isced_r[_n+1]!=. & isced_r==. & minwave==wave
* If the variable has values in multiple waves, the correct one according to the logic of the questionnaire must be the first
* Check whether it is valorised:
count if isced_r==. & tx>1 & minwave==wave
drop x tx

* I always keep the first case in which they declared it
keep if wave==minwave
keep country mergeid isced_r
ren isced_r dm_education
label define dm_education 0 "none" 1 "Primary education - First stage of basic education" ///
2 "Lower secondary education - Second stage of basic education" ///
3 "(Upper) secondary education" 4 "Post-secondary non tertiary education" ///
5 "First stage of tertiary education (not leading directly to an advanced research qualification)" ///
6 "Second stage of tertiary education (leading to an advanced research qualification)" 95 "still in school" 97 "other" ///
.a "don't know" .b "refusal"
label value dm_education dm_education
sort country mergeid
save education, replace

* Citizenship: only once for each individual in the longitudinal sample.
* WAVE 3 did not contain a refreshment sample, so we do not need it
use "$root/Wave 1/sharew1_rel6-0-0_dn", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_dn"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_dn"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_dn"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_dn"
recode wave .=6
sharetom5 _all, replace

egen minwave=min(wave), by(country mergeid)
g xx=1
egen tot_waves=sum(xx), by(country mergeid)
drop xx

ren dn004_ dm_bornlocal
label var dm_bornlocal "born in the country"
g x=(dm_bornlocal!=. & dm_bornlocal!=.a & dm_bornlocal!=.b)
egen tx=sum(x), by(country mergeid)
tab tx
* For all those with only one declaration, the value should be in the first wave
count if dm_bornlocal==. & tx==1 & minwave==wave
sort mergeid wave
* In some case it is not the case, so I get back the value
replace dm_bornlocal=dm_bornlocal[_n+1] if mergeid==mergeid[_n+1] & dm_bornlocal[_n+1]!=. & dm_bornlocal==. & minwave==wave
* If the variable has values in multiple waves, the correct one according to the logic of the questionnaire must be the first
* Check whether it is valorised:
count if dm_bornlocal==. & tx>1 & minwave==wave
drop x tx

ren dn005c dm_bornabroad_where
label var dm_bornabroad_where "born abroad: where"
g x=(dm_bornabroad_where!=. & dm_bornabroad_where!=.a & dm_bornabroad_where!=.b)
egen tx=sum(x), by(country mergeid)
tab tx
* For all those with only one declaration, the value should be in the first wave
count if dm_bornabroad_where==. & tx==1 & minwave==wave
sort mergeid wave
* In some case it is not the case, so I get back the value
replace dm_bornabroad_where=dm_bornabroad_where[_n+1] if mergeid==mergeid[_n+1] & dm_bornabroad_where[_n+1]!=. & dm_bornabroad_where==. & minwave==wave
* If the variable has values in multiple waves, the correct one according to the logic of the questionnaire must be the first
* Check whether it is valorised:
count if dm_bornabroad_where==. & tx>1 & minwave==wave
drop x tx

ren dn007_ dm_citizen
label var dm_citizen "citizen of the country"
g x=(dm_citizen!=. & dm_citizen!=.a & dm_citizen!=.b)
egen tx=sum(x), by(country mergeid)
tab tx
* For all those with only one declaration, the value should be in the first wave
count if dm_citizen==. & tx==1 & minwave==wave
sort mergeid wave
* In some case it is not the case, so I get back the value
replace dm_citizen=dm_citizen[_n+1] if mergeid==mergeid[_n+1] & dm_citizen[_n+1]!=. & dm_citizen==. & minwave==wave
* If the variable has values in multiple waves, the correct one according to the logic of the questionnaire must be the first
* Check whether it is valorised:
count if dm_citizen==. & tx>1 & minwave==wave
drop x tx

ren dn008c dm_citizen_where
label var dm_citizen_where "citizen of another country: where"
g x=(dm_citizen_where!=. & dm_citizen_where!=.a & dm_citizen_where!=.b)
egen tx=sum(x), by(country mergeid)
tab tx
* For all those with only one declaration, the value should be in the first wave
count if dm_citizen_where==. & tx==1 & minwave==wave
sort mergeid wave
* In some case it is not the case, so I get back the value
replace dm_citizen_where=dm_citizen_where[_n+1] if mergeid==mergeid[_n+1] & dm_citizen_where[_n+1]!=. & dm_citizen_where==. & minwave==wave
* If the variable has values in multiple waves, the correct one according to the logic of the questionnaire must be the first
* Check whether it is valorised:
count if dm_citizen_where==. & tx>1 & minwave==wave
drop x tx	

keep if wave==minwave
keep country mergeid dm_bornlocal dm_bornabroad_where dm_citizen dm_citizen_where
sort country mergeid
save citizenship, replace

* Marital status: may change every wave; 
use "$root/Wave 1/sharew1_rel6-0-0_dn", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_dn"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_dn"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_dn"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_dn"
recode wave .=6
sharetom5 _all, replace

egen minwave=min(wave), by(country mergeid)
g xx=1
egen tot_waves=sum(xx), by(country mergeid)
drop xx

sort mergeid wave
ren dn014_ dm_marstatus
label var dm_marstatus "marital status"
replace dm_marstatus=dm_marstatus[_n-1] if wave==2 & dn044_==5 & mergeid==mergeid[_n-1]
replace dm_marstatus=dm_marstatus[_n-1] if wave==4 & dn044_==5 & mergeid==mergeid[_n-1]
replace dm_marstatus=dm_marstatus[_n-1] if wave==5 & dn044_==5 & mergeid==mergeid[_n-1]
replace dm_marstatus=dm_marstatus[_n-1] if wave==6 & dn044_==5 & mergeid==mergeid[_n-1]
keep country wave mergeid dm_marstatus
sort country mergeid wave
save marital, replace

* Health
use "$root/Wave 1/sharew1_rel6-0-0_gv_health", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_gv_health"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_gv_health"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_gv_health"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_gv_health"
recode wave .=6
sharetom5 _all, replace
sort mergeid wave
ren numeracy dm_numeracy
label var dm_numeracy	"numeracy score (cognitive functioning)"
ren orienti dm_orienti
label var dm_orienti	"orientation to date, month, year and day of week"
ren eurod dm_eurodep
label var dm_eurodep	"Depression scale EURO-D"
ren sphus dm_ghealth
label var dm_ghealth	"self-perceived health US version"
ren gali dm_gali
label var dm_gali	"limitations with activities (gali)"
ren adl dm_adl
label var dm_adl	"number of limitations with activities of daily living (adl)"
ren iadl dm_iadl
label var dm_iadl	"iadl"
keep country mergeid wave dm_*
sort country mergeid wave
save health, replace

* Tenure
use "$root/Wave 1/sharew1_rel6-0-0_ho", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_ho"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_ho"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_ho"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_ho"
recode wave .=6
sharetom5 _all
sort country mergeid wave
save tenure, replace


use cover, clear
drop if interview==0
sort country mergeid wave
merge 1:1 country mergeid wave using tenure

* To avoid problems: to those who have ho002, I keep it
* For those for whom it is missing, I give them the one of their family respondent
egen tt=sum(hou_resp), by(hhid_current wave)
tab tt
g ho002_houresp=ho002 if hou_resp==1
egen ho002_mean=mean(ho002_houresp), by(country hhid_current wave)
tab ho002_mean, miss
replace ho002_=ho002_mean if ho002_==.
keep mergeid country wave ho002_
ren ho002_ dm_tenure
sort country mergeid wave
save tenure, replace

* I put it all together
use age, clear
sort country mergeid
merge m:1 country mergeid using education
drop _merge
sort country mergeid
merge m:1 country mergeid using citizenship
drop _merge
sort country mergeid wave
merge 1:1 country mergeid wave using marital
drop _merge
merge 1:1 country mergeid wave using health
drop _merge
merge 1:1 country mergeid wave using tenure
drop _merge
save demographic, replace


*************************************************************************************************	
* CARE AND TRANSFERS SECTION

use "$root/Wave 1/sharew1_rel6-0-0_ch", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_ch"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_ch"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_ch"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_ch"
recode wave .=6
sharetom5 _all, replace
save children, replace

use children, clear
keep mergeid wave ch021_ ch001_
sort wave mergeid 
merge wave mergeid using cover
tab _merge
keep if _merge==3
drop _merge

tab ch021_ wave if fam_resp==0, miss
tab ch021_ wave if fam_resp==1, miss

* In waves 1-2 the question on grandchildren was asked only if the couple had
* children alive
tab ch001_ if wave>=1 & wave<=2 & ch021_==. & fam_resp==1, miss

sum ch021_, d
replace ch021_=. if ch021_>100

sort wave mergeid
save grandchildren, replace

* Social network wave 4
use "$root/Wave 4/sharew4_rel6-0-0_sn", clear
sharetom5 _all, replace
g wave=4
keep mergeid wave sn005_*
sort wave mergeid
save social_net, replace


use "$root/Wave 1/sharew1_rel6-0-0_sp", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_sp"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_sp"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_sp"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_sp"
recode wave .=6
sharetom5 _all, replace
save care, replace

use care, clear
sort wave mergeid
merge 1:1 wave mergeid using cover
keep if _merge==3
drop _merge
sort wave mergeid
merge 1:1 wave mergeid using grandchildren
keep if _merge==3
drop _merge
sort wave mergeid
merge 1:1 wave mergeid using social_net
tab wave _merge
drop _merge

tab sp002_ wave if fam_resp==1, miss
tab sp002_ wave if fam_resp==0, miss

tab sp008_ wave if fam_resp==1, miss
tab sp008_ wave if fam_resp==0, miss

tab sp009_1 wave, miss

* in wave 4 those that are members of the social network are mentioned separately 
* and coded from 101 to 107
* I first make them comparable
forvalues i=1(1)7 {
	replace sn005_`i'=sn005_`i'+1 if sn005_`i'>=25 & sn005_`i'<=27
	replace sn005_`i'=25 if sn005_`i'==11
	replace sn005_`i'=sn005_`i'-1 if sn005_`i'>=12 & sn005_`i'<=28
	replace sn005_`i'=sn005_`i'+9 if sn005_`i'>=10 & sn005_`i'<=27
	replace sn005_`i'=sn005_`i'+1 if sn005_`i'>=34 & sn005_`i'<=36
	}
*

forvalues i=1(1)3 {
	forvalues j=1(1)7 {
		replace sp009_`i'sp=sn005_`j' if sp009_`i'sp==10`j'
		}
	}
*

g care_to_parents=sp008_==1 & ((sp009_1>=2 & sp009_1<=7) | (sp009_2>=2 & sp009_2<=7) | (sp009_3>=2 & sp009_3<=7)) & wave!=4
replace care_to_parents=1 if sp008_==1 & ((sp009_1sp>=2 & sp009_1sp<=7) | (sp009_2sp>=2 & sp009_2sp<=7) | (sp009_3sp>=2 & sp009_3sp<=7)) & wave==4

replace care_to_parents=sp008_ if sp008_==. | sp008_==.a | sp008_==.b
replace care_to_parents=. if sp008_==1 & (sp009_1==.a | sp009_1==.b | sp009_2==.a | sp009_2==.b | sp009_3==.a | sp009_3==.b) & wave!=4
replace care_to_parents=. if sp008_==1 & (sp009_1sp==.a | sp009_1sp==.b | sp009_2sp==.a | sp009_2sp==.b | sp009_3sp==.a | sp009_3sp==.b) & wave==4

g care_to_grandch=sp014_==1
replace care_to_grandch=. if ch021_==0 | ch021_==. | ch021_==.a | ch021_==.b
replace care_to_grandch=. if sp014_==. | sp014_==.a | sp014_==.b

* Be careful: care_to_parents is missing for fam_resp==0 in waves 4-5
* care_to_grandch is missing for fam_resp==0 in waves 4-5-6

keep wave mergeid care* country
sort country mergeid wave
save care_short, replace

use "$root/Wave 1/sharew1_rel6-0-0_ft", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_ft"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_ft"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_ft"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_ft"
recode wave .=6
sharetom5 _all, replace
sort wave mergeid
merge 1:1 wave mergeid using cover
keep if _merge==3
drop _merge
sort wave mergeid
merge 1:1 wave mergeid using social_net
tab wave _merge
drop _merge

tab ft002_ wave if fin_resp==1, miss
tab ft003_1 wave if ft002_==1, miss

* in wave 4 those that are members of the social network are mentioned separately 
* and coded from 101 to 107
* I first make them comparable
forvalues i=1(1)7 {
	replace sn005_`i'=sn005_`i'+1 if sn005_`i'>=25 & sn005_`i'<=27
	replace sn005_`i'=25 if sn005_`i'==11
	replace sn005_`i'=sn005_`i'-1 if sn005_`i'>=12 & sn005_`i'<=28
	replace sn005_`i'=sn005_`i'+9 if sn005_`i'>=10 & sn005_`i'<=27
	replace sn005_`i'=sn005_`i'+1 if sn005_`i'>=34 & sn005_`i'<=36
	}
*

forvalues i=1(1)3 {
	forvalues j=1(1)7 {
		replace ft003_`i'ft=sn005_`j' if ft003_`i'ft==10`j'
		}
	}
*

g ft_to_children=ft002_==1 & ((ft003_1>=10 & ft003_1<=22) | (ft003_2>=10 & ft003_2<=22) | (ft003_3>=10 & ft003_3<=22)) & wave!=4
replace ft_to_children=1 if ft002_==1 & ((ft003_1ft>=10 & ft003_1ft<=22) | (ft003_2ft>=10 & ft003_2ft<=22) | (ft003_3ft>=10 & ft003_3ft<=22) ///
	| ft003_1ft==34 | ft003_2ft==34 | ft003_3ft==34) & wave==4

replace ft_to_children=ft002_ if ft002_==. | ft002_==.a | ft002_==.b
replace ft_to_children=. if ft002_==1 & (ft003_1==.a | ft003_1==.b | ft003_2==.a | ft003_2==.b | ft003_3==.a | ft003_3==.b) & wave!=4
replace ft_to_children=. if ft002_==1 & (ft003_1ft==.a | ft003_1ft==.b | ft003_2ft==.a | ft003_2ft==.b | ft003_3ft==.a | ft003_3ft==.b) & wave==4

keep if fin_resp==1
sort wave mergeid
save transfers, replace

use transfers, clear
keep country wave mergeid ft_to_children
sort country mergeid wave
save transfers_short, replace

*************************************************************************************************	
* EMPLOYMENT SECTION

use "$root/Wave 1/sharew1_rel6-0-0_ep", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_ep"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_ep"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_ep"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_ep"
recode wave .=6
sharetom5 _all, replace
save employmentraw, replace

use employmentraw, clear
* Employment status: may change every wave
ren ep005_ em_employment
label var em_employment "employment status"

ren ep002_ em_worked_anyway
label var em_worked_anyway "did nevertheless any work last week"
ren ep003_ em_temporary_away
label var em_temporary_away "temporary away from work"

ren ep006_ em_everworked
label var em_everworked "ever worked"
replace em_everworked=1 if em_employment==1 | em_employment==2 | em_employment==3 | em_worked_anyway==1 | em_temporary_away==1
* Note: the question about everworked is not asked again to longitudinal individuals
sort mergeid wave
* This rule should not change anyone
replace em_everworked=em_everworked[_n-1] if em_everworked==0 & em_everworked[_n-1]==1 & wave==2 & mergeid==mergeid[_n-1]
* This should change some cases
replace em_everworked=em_everworked[_n-1] if em_everworked==. & wave==2 & mergeid==mergeid[_n-1]
replace em_everworked=em_everworked[_n-1] if em_everworked==0 & em_everworked[_n-1]==1 & wave==4 & mergeid==mergeid[_n-1]
replace em_everworked=em_everworked[_n-1] if em_everworked==. & wave==4 & mergeid==mergeid[_n-1]
replace em_everworked=em_everworked[_n-1] if em_everworked==0 & em_everworked[_n-1]==1 & wave==5 & mergeid==mergeid[_n-1]
replace em_everworked=em_everworked[_n-1] if em_everworked==. & wave==5 & mergeid==mergeid[_n-1]
replace em_everworked=em_everworked[_n-1] if em_everworked==0 & em_everworked[_n-1]==1 & wave==6 & mergeid==mergeid[_n-1]
replace em_everworked=em_everworked[_n-1] if em_everworked==. & wave==6 & mergeid==mergeid[_n-1]

ren ep009_1 em_mainjob_type
label var em_mainjob_type "Main job: type"
replace em_mainjob_type=ep009_ if wave==2 | wave==4 | wave==5 | wave==6
* For those who are employed it is always asked, apart from some mistakes (in those cases I trace it back)
tab em_mainjob_type wave if em_employment==2, miss
* But it is not asked to those who worked anyway if they are longitudinal
tab em_mainjob_type wave if em_worked_anyway==1, miss
sort mergeid wave
replace em_mainjob_type=em_mainjob_type[_n-1] if em_mainjob_type==. & wave==2 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_mainjob_type=em_mainjob_type[_n-1] if em_mainjob_type==. & wave==4 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
* Note: in waves 5-6 category 2 is public employee and not civil servant
replace em_mainjob_type=em_mainjob_type[_n-1] if em_mainjob_type==. & wave==5 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_mainjob_type=em_mainjob_type[_n-1] if em_mainjob_type==. & wave==6 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)

ren ep010_1 em_mainjob_yrstart
label var em_mainjob_yrstart "Main job: when started"
replace em_mainjob_yrstart=ep010_ if wave==2 | wave==4 | wave==5 | wave==6
* This is asked only to the non longitudinal or those who declared to have changed job
tab em_mainjob_yrstart wave if em_employment==2, miss
sort mergeid wave
replace em_mainjob_yrstart=em_mainjob_yrstart[_n-1] if em_mainjob_yrstart==. & wave==2 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type>=1 & em_mainjob_type<=3 & ///
	((ep125_==1 & ep141d1!=1 & ep141d2!=1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
replace em_mainjob_yrstart=em_mainjob_yrstart[_n-1] if em_mainjob_yrstart==. & wave==4 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type>=1 & em_mainjob_type<=3 & ///
	((ep125_==1 & ep141d1!=1 & ep141d2!=1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
replace em_mainjob_yrstart=em_mainjob_yrstart[_n-1] if em_mainjob_yrstart==. & wave==5 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type>=1 & em_mainjob_type<=3 & ///
	((ep125_==1 & ep141d1!=1 & ep141d2!=1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
replace em_mainjob_yrstart=em_mainjob_yrstart[_n-1] if em_mainjob_yrstart==. & wave==6 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type>=1 & em_mainjob_type<=3 & ///
	((ep125_==1 & ep141d1!=1 & ep141d2!=1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
tab em_mainjob_yrstart wave if em_mainjob_type>=1 & em_mainjob_type<=3, miss

ren ep011_1 em_mainjob_term
label var em_mainjob_term "Main job: permanent or not (only employee or civil servants)"
replace em_mainjob_term=ep011_ if wave==2 | wave==4 | wave==5 | wave==6
* This is asked only to the non longitudinal or those who declared to have changed job
tab em_mainjob_term wave if em_mainjob_type>=1 & em_mainjob_type<=2, miss
sort mergeid wave
replace em_mainjob_term=em_mainjob_term[_n-1] if em_mainjob_term==. & wave==2 & mergeid==mergeid[_n-1] & ///
	em_mainjob_type>=1 & em_mainjob_type<=2 & ((ep125_==1 & ep141dno==1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
replace em_mainjob_term=em_mainjob_term[_n-1] if em_mainjob_term==. & wave==4 & mergeid==mergeid[_n-1] & ///
	em_mainjob_type>=1 & em_mainjob_type<=2 & ((ep125_==1 & ep141dno==1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
replace em_mainjob_term=em_mainjob_term[_n-1] if em_mainjob_term==. & wave==5 & mergeid==mergeid[_n-1] & ///
	em_mainjob_type>=1 & em_mainjob_type<=2 & ((ep125_==1 & ep141dno==1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
replace em_mainjob_term=em_mainjob_term[_n-1] if em_mainjob_term==. & wave==6 & mergeid==mergeid[_n-1] & ///
	em_mainjob_type>=1 & em_mainjob_type<=2 & ((ep125_==1 & ep141dno==1) | (ep141dno==. & em_mainjob_type==em_mainjob_type[_n-1]))
tab em_mainjob_term wave if em_mainjob_type>=1 & em_mainjob_type<=2, miss

ren ep013_1 em_mainjob_hh
label var em_mainjob_hh "Main job: usual hours/week"
replace em_mainjob_hh=ep013_ if wave==2 | wave==4 | wave==5 | wave==6
* For those who are employed it is always asked, apart from some mistakes (in those cases I trace it back)
tab em_mainjob_hh wave if em_employment==2, miss
* But it is not asked to those who worked anyway if they are longitudinal
tab em_mainjob_hh wave if em_worked_anyway==1, miss
sort mergeid wave
replace em_mainjob_hh=em_mainjob_hh[_n-1] if em_mainjob_hh==. & wave==2 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_mainjob_hh=em_mainjob_hh[_n-1] if em_mainjob_hh==. & wave==4 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_mainjob_hh=em_mainjob_hh[_n-1] if em_mainjob_hh==. & wave==5 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_mainjob_hh=em_mainjob_hh[_n-1] if em_mainjob_hh==. & wave==6 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
tab em_mainjob_hh wave if em_mainjob_type>=1 & em_mainjob_type<=3, miss

ren ep014_1 em_mainjob_months
label var em_mainjob_months "Main job: usual # months"
replace em_mainjob_months=ep014_ if wave==2  | wave==4 | wave==5
* For those who are employed it is always asked, apart from some mistakes (in those cases I trace it back)
tab em_mainjob_months wave if em_employment==2, miss
* But it is not asked to those who worked anyway if they are longitudinal
tab em_mainjob_months wave if em_worked_anyway==1, miss
sort mergeid wave
replace em_mainjob_months=em_mainjob_months[_n-1] if em_mainjob_months==. & wave==2 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_mainjob_months=em_mainjob_months[_n-1] if em_mainjob_months==. & wave==4 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_mainjob_months=em_mainjob_months[_n-1] if em_mainjob_months==. & wave==5 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
* It is not asked in wave 6

ren ep019_1 em_mainjob_public
label var em_mainjob_public "Main job: public sector (only for employee)"
replace em_mainjob_public=ep019_ if wave==2 | wave==4
* This is asked only to the non longitudinal or those who declared to have changed job
tab em_mainjob_public wave if em_mainjob_type>=1 & em_mainjob_type<=2, miss
sort mergeid wave
replace em_mainjob_public=em_mainjob_public[_n-1] if em_mainjob_public==. & wave==2 & mergeid==mergeid[_n-1] ///
& em_mainjob_type==1 & em_mainjob_type[_n-1]==1
replace em_mainjob_public=em_mainjob_public[_n-1] if em_mainjob_public==. & wave==4 & mergeid==mergeid[_n-1] ///
& em_mainjob_type==1 & em_mainjob_type[_n-1]==1
*There is no question ep019_1 in waves 5-6, because it's implicit in question ep009_
tab em_mainjob_public wave if em_mainjob_type==1, miss

ren ep041e_1 em_mainjob_payG
label var em_mainjob_payG "Main job (employees and civil servants): monhtly payment (BEFORE TAXES)"
replace em_mainjob_payG=ep041e if wave==2
* This variable refers to the frequency of payment stated in var ep038
replace ep038_=ep038_1 if wave==1
tab ep038_ wave if em_mainjob_payG!=. & em_mainjob_payG!=.a & em_mainjob_payG!=.b, miss
replace em_mainjob_payG=em_mainjob_payG*52/12 if ep038_==1
replace em_mainjob_payG=em_mainjob_payG*26/12 if ep038_==2
replace em_mainjob_payG=em_mainjob_payG/3 if ep038_==4
replace em_mainjob_payG=em_mainjob_payG/6 if ep038_==5
replace em_mainjob_payG=em_mainjob_payG/12 if ep038_==6
* In case of "Other frequency, specify, I impose missing
replace em_mainjob_payG=. if ep038_==97 | ep038_==.
sort mergeid wave
replace em_mainjob_payG=em_mainjob_payG[_n-1] if em_mainjob_payG==. & wave==2 & mergeid==mergeid[_n-1] ///
& ((em_mainjob_type==1 & em_mainjob_type[_n-1]==1) | (em_mainjob_type==2 & em_mainjob_type[_n-1]==2))
* There is no question on monthly pay in waves 5-6

ren ep201e_1 em_mainjob_payN
label var em_mainjob_payN "Main job (employees and civil servants): monhtly payment (AFTER TAXES)"
replace em_mainjob_payN=ep201e if wave==2
* This variable refers to the frequency of payment stated in var ep038
tab ep038_ wave if em_mainjob_payG!=. & em_mainjob_payG!=.a & em_mainjob_payG!=.b, miss
replace em_mainjob_payN=em_mainjob_payN*52/12 if ep038_==1
replace em_mainjob_payN=em_mainjob_payN*26/12 if ep038_==2
replace em_mainjob_payN=em_mainjob_payN/3 if ep038_==4
replace em_mainjob_payN=em_mainjob_payN/6 if ep038_==5
replace em_mainjob_payN=em_mainjob_payN/12 if ep038_==6
* In case of "Other frequency, specify, I impose missing
replace em_mainjob_payN=. if ep038_==97 | ep038_==.
sort mergeid wave
replace em_mainjob_payN=em_mainjob_payN[_n-1] if em_mainjob_payN==. & wave==2 & mergeid==mergeid[_n-1] ///
& ((em_mainjob_type==1 & em_mainjob_type[_n-1]==1) | (em_mainjob_type==2 & em_mainjob_type[_n-1]==2))
* There is no question on monthly pay in waves 5-6

ren ep045e_1 em_mainjob_profitsG
label var em_mainjob_profitsG "Main job (self-employed): yearly profits (BEFORE TAXES)"
replace em_mainjob_profitsG=ep045e if wave==2
sort mergeid wave
replace em_mainjob_profitsG=em_mainjob_profitsG[_n-1] if em_mainjob_profitsG==. & wave==2 & mergeid==mergeid[_n-1] ///
& em_mainjob_type==3 & em_mainjob_type[_n-1]==3
* There is no question on yearly profits in waves 5-6

ren ep305e em_mainjob_profitsN
label var em_mainjob_profitsG "Main job (self-employed): yearly profits (AFTER TAXES)"
* There is no question on yearly profits in waves 5-6

ren ep051_ em_lastjob_type
label var em_lastjob_type "Last job: type"
sort mergeid wave
replace em_lastjob_type=em_lastjob_type[_n-1] if em_lastjob_type==. & wave==2 & mergeid==mergeid[_n-1] ///
	& em_lastjob_type[_n-1]!=. & em_lastjob_type[_n-1]!=.a & em_lastjob_type[_n-1]!=.b
replace em_lastjob_type=em_mainjob_type[_n-1] if em_lastjob_type==. & wave==2 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type[_n-1]!=. & em_mainjob_type[_n-1]!=.a & em_mainjob_type[_n-1]!=.b & em_everworked==1
replace em_lastjob_type=em_lastjob_type[_n-1] if em_lastjob_type==. & wave==4 & mergeid==mergeid[_n-1] ///
	& em_lastjob_type[_n-1]!=. & em_lastjob_type[_n-1]!=.a & em_lastjob_type[_n-1]!=.b
replace em_lastjob_type=em_mainjob_type[_n-1] if em_lastjob_type==. & wave==4 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type[_n-1]!=. & em_mainjob_type[_n-1]!=.a & em_mainjob_type[_n-1]!=.b & em_everworked==1
* Note: from wave 5 the second category is not civil servant but public employee
replace em_lastjob_type=em_lastjob_type[_n-1] if em_lastjob_type==. & wave==5 & mergeid==mergeid[_n-1] ///
	& em_lastjob_type[_n-1]!=. & em_lastjob_type[_n-1]!=.a & em_lastjob_type[_n-1]!=.b
replace em_lastjob_type=em_mainjob_type[_n-1] if em_lastjob_type==. & wave==5 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type[_n-1]!=. & em_mainjob_type[_n-1]!=.a & em_mainjob_type[_n-1]!=.b & em_everworked==1
replace em_lastjob_type=em_lastjob_type[_n-1] if em_lastjob_type==. & wave==6 & mergeid==mergeid[_n-1] ///
	& em_lastjob_type[_n-1]!=. & em_lastjob_type[_n-1]!=.a & em_lastjob_type[_n-1]!=.b
replace em_lastjob_type=em_mainjob_type[_n-1] if em_lastjob_type==. & wave==6 & mergeid==mergeid[_n-1] ///
	& em_mainjob_type[_n-1]!=. & em_mainjob_type[_n-1]!=.a & em_mainjob_type[_n-1]!=.b & em_everworked==1
tab em_lastjob_type wave, nofreq col miss	
	
ren ep055_ em_lastjob_public
label var em_lastjob_public "Last job: public sector (only if employee)"
sort mergeid wave
replace em_lastjob_public=em_lastjob_public[_n-1] if em_lastjob_type==1 & em_lastjob_public==. & wave==2 & mergeid==mergeid[_n-1] ///
& em_lastjob_public[_n-1]!=. & em_lastjob_public[_n-1]!=.a & em_lastjob_public[_n-1]!=.b
replace em_lastjob_type=em_mainjob_public[_n-1] if em_lastjob_type==1 & em_lastjob_public==. & wave==2 & mergeid==mergeid[_n-1] ///
& em_mainjob_public[_n-1]!=. & em_mainjob_public[_n-1]!=.a & em_mainjob_public[_n-1]!=.b & em_everworked==1
replace em_lastjob_type=em_lastjob_public[_n-1] if em_lastjob_type==1 & em_lastjob_public==. & wave==4 & mergeid==mergeid[_n-1] ///
& em_lastjob_public[_n-1]!=. & em_lastjob_public[_n-1]!=.a & em_lastjob_public[_n-1]!=.b
replace em_lastjob_type=em_mainjob_public[_n-1] if em_lastjob_type==1 & em_lastjob_public==. & wave==4 & mergeid==mergeid[_n-1] ///
& em_mainjob_public[_n-1]!=. & em_mainjob_public[_n-1]!=.a & em_mainjob_public[_n-1]!=.b & em_everworked==1
* Not asked in waves 5-6 (it's implicit in ep051_)

ren ep321_ em_secondjob_hh
label var em_secondjob_hh "second job: usual hours/week"
sort mergeid wave
replace em_secondjob_hh=em_secondjob_hh[_n-1] if em_secondjob_hh==. & wave==2 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_secondjob_hh=em_secondjob_hh[_n-1] if em_secondjob_hh==. & wave==4 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_secondjob_hh=em_secondjob_hh[_n-1] if em_secondjob_hh==. & wave==5 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_secondjob_hh=em_secondjob_hh[_n-1] if em_secondjob_hh==. & wave==6 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)

ren ep322_ em_secondjob_months
label var em_secondjob_months "second job: usual # months"
sort mergeid wave
replace em_secondjob_months=em_secondjob_months[_n-1] if em_secondjob_months==. & wave==2 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_secondjob_months=em_secondjob_months[_n-1] if em_secondjob_months==. & wave==4 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_secondjob_months=em_secondjob_months[_n-1] if em_secondjob_months==. & wave==5 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)
replace em_secondjob_months=em_secondjob_months[_n-1] if em_secondjob_months==. & wave==6 & mergeid==mergeid[_n-1] ///
	& (em_employment==2 | em_worked_anyway==1) & (em_employment[_n-1]==2 | em_worked_anyway[_n-1]==1 | em_temporary_away[_n-1]==1)

keep country mergeid wave em_*
sort country mergeid wave
save employment, replace

*************************************************************************************************	
* PENSION CLAIM SECTION

use employmentraw, clear

sum ep098d* if ep097_==.a | ep097_==.b

forvalues i=1(1)7 {
ren ep098d`i' cl_pensiond`i'
replace cl_pensiond`i'=ep097_ if ep097_==.a | ep097_==.b
replace cl_pensiond`i'=0 if ep097_==5
}

* Usually countries that did not have a category in a wave put it as 0 in that wave
table country wave if (ep097_==1 | ep097_==5), c(mean cl_pensiond2)
tab country wave if (ep097_==1 | ep097_==5) & cl_pensiond2==.
replace cl_pensiond2=0 if (ep097_==1 | ep097_==5) & cl_pensiond2==. & wave==6 & (country==13 | country==15 | country==17)

table country wave if (ep097_==1 | ep097_==5), c(mean cl_pensiond4)
tab country wave if (ep097_==1 | ep097_==5) & cl_pensiond4==.
replace cl_pensiond4=0 if (ep097_==1 | ep097_==5) & cl_pensiond4==. & wave==6 & (country==34)

table country wave if (ep097_==1 | ep097_==5), c(mean cl_pensiond5)
tab country wave if (ep097_==1 | ep097_==5) & cl_pensiond5==.
replace cl_pensiond5=0 if (ep097_==1 | ep097_==5) & cl_pensiond5==. & wave==6 & (country==12 | country==15 | country==17 | country==34)

* For the others, which are specific to some countries in the first two waves
* we do not do the same procedure
table country wave if cl_pensiond1>=0 & cl_pensiond1<=1, c(mean cl_pensiond6)
tab country wave if cl_pensiond1>=0 & cl_pensiond1<=1 & cl_pensiond6==.

g tot=cl_pensiond1+cl_pensiond2+cl_pensiond3+cl_pensiond4+cl_pensiond5+cl_pensiond6+cl_pensiond7

ren ep098dno cl_pensiondno
replace cl_pensiondno=ep097_ if ep097_==.a | ep097_==.b
replace cl_pensiondno=0 if ep097_==5 | ep097_==96

ren ep097 cl_pension
recode cl_pension 5=0
recode cl_pension 96=0
label var cl_pension "Entitled to pension"

tab cl_pensiondno wave if tot==0 & cl_pension==1

forvalues i=1(1)7 {
ren ep102_`i' cl_pension`i'_compulsory
}

forvalues i=1(1)7 {
ren ep103_`i' cl_pension`i'_yrcontr
}

g cl_yrcontr=max(cl_pension1_yrcontr, cl_pension2_yrcontr, cl_pension3_yrcontr, cl_pension4_yrcontr, cl_pension5_yrcontr, ///
cl_pension6_yrcontr, cl_pension7_yrcontr)
forvalues i=1(1)7 {
tab cl_pension`i'_yrcontr if cl_pensiond`i'==1, miss
replace cl_yrcontr=. if cl_pensiond`i'==1 & (cl_pension`i'_yrcontr==. | cl_pension`i'_yrcontr==.a | cl_pension`i'_yrcontr==.b)
}
label var cl_yrcontr	"Maximum value for years of contribution"
tab cl_yrcontr cl_pension, miss nofreq col

forvalues i=1(1)7 {
ren ep106_`i' cl_pension`i'_expage
}
g cl_expage=min(cl_pension1_expage, cl_pension2_expage, cl_pension3_expage, cl_pension4_expage, cl_pension5_expage, ///
cl_pension6_expage, cl_pension7_expage)
forvalues i=1(1)7 {
tab cl_pension`i'_expage if cl_pensiond`i'==1, miss
replace cl_expage=. if cl_pensiond`i'==1 & (cl_pension`i'_expage==. | cl_pension`i'_expage==.a | cl_pension`i'_expage==.b)
}
label var cl_expage	"Minimum value for expected age of pension start"
tab cl_expage cl_pension, miss

forvalues i=1(1)7 {
ren ep109_`i' cl_pension`i'_replacement
tab cl_pension`i'_replacement if cl_pensiond`i'==1, miss
}

g cl_replacement=0
forvalues i=1(1)7 {
replace cl_replacement=cl_replacement+cl_pension`i'_replacement if cl_pensiond`i'==1
}
replace cl_replacement=. if (cl_pension1_replacement==. | cl_pension1_replacement==.a | cl_pension1_replacement==.b) & /// 
(cl_pension2_replacement==. | cl_pension2_replacement==.a | cl_pension2_replacement==.b) & ///
(cl_pension3_replacement==. | cl_pension3_replacement==.a | cl_pension3_replacement==.b) & ///
(cl_pension4_replacement==. | cl_pension4_replacement==.a | cl_pension4_replacement==.b) & ///
(cl_pension5_replacement==. | cl_pension5_replacement==.a | cl_pension5_replacement==.b) & ///
(cl_pension6_replacement==. | cl_pension6_replacement==.a | cl_pension6_replacement==.b) & ///
(cl_pension7_replacement==. | cl_pension7_replacement==.a | cl_pension7_replacement==.b)

label var cl_replacement	"Sum of all replacement rate for each pension"
tab cl_replacement cl_pension, miss

keep country mergeid wave cl_*
sort country mergeid wave
save pension_claim, replace

capture erase employmentraw.dta

*************************************************************************************************
* INCOME SECTION
use cover, clear
drop if interview==0
keep mergeid wave int_year
sort mergeid wave
save interview_year, replace

use "$root/Wave 1/sharew1_rel6-0-0_gv_imputations.dta", clear
g wave=1
append using "$root/Wave 2/sharew2_rel6-0-0_gv_imputations.dta"
recode wave .=2
append using "$root/Wave 4/sharew4_rel6-0-0_gv_imputations.dta"
recode wave .=4
append using "$root/Wave 5/sharew5_rel6-0-0_gv_imputations.dta"
recode wave .=5
append using "$root/Wave 6/sharew6_rel6-0-0_gv_imputations.dta"
recode wave .=6
sharetom5 _all, replace
sort country mergeid wave
save income_imputation_raw, replace

use employment, clear
keep country mergeid wave em_employment
sort country mergeid wave
merge 1:m country mergeid wave using income_imputation_raw
g ylabour=ydip+yind
g zero=ylabour==0
tab wave zero if em_employment==2, nofreq row
tab country zero if em_employment==2 & wave==1, nofreq row
tab country zero if em_employment==2 & wave==2, nofreq row
tab country zero if em_employment==2 & wave==4, nofreq row
tab country zero if em_employment==2 & wave==5, nofreq row
tab country zero if em_employment==2 & wave==6, nofreq row

use income_imputation_raw, clear
g hhid_current=hhid1 if wave==1
replace hhid_current=hhid2 if wave==2
replace hhid_current=hhid4 if wave==4
replace hhid_current=hhid5 if wave==5
replace hhid_current=hhid6 if wave==6
drop hhid1 hhid2 hhid4 hhid5 hhid6

g mergeidp=mergeidp1 if wave==1
replace mergeidp=mergeidp2 if wave==2
replace mergeidp=mergeidp4 if wave==4
replace mergeidp=mergeidp5 if wave==5
replace mergeidp=mergeidp6 if wave==6
drop mergeidp1 mergeidp2 mergeidp4 mergeidp5 mergeidp6

foreach var in rhre fahc fohc bacc bsmf slti liab hnfass hnetw thinc hrass {
	egen double _`var'=mean(`var'), by(hhid_current implicat wave)
	sum `var' _`var'
	compare `var' _`var'
	}

* for fahc it is due to some household members having "not applicable"
g dif=fahc-_fahc
sort wave hhid_current mergeid implicat
order wave hhid_current mergeid mergeidp implicat fahc _fahc fahc_f
browse if abs(dif)>1
replace fahc=_fahc*2 if abs(dif)>1 & fahc_f==.i
drop dif

* for fohc it is due to some household members having "not applicable"
g dif=fohc-_fohc
sort wave hhid_current mergeid implicat
order wave hhid_current mergeid mergeidp implicat fohc _fohc fohc_f
browse if abs(dif)>1
replace fohc=_fohc*2 if abs(dif)>1 & fohc_f==.i
drop dif

foreach var in rhre fahc fohc thinc {
	gen double temp_imp=`var' if `var'_f>=4 & `var'_f<=11
	bys implicat hhid_current wave: egen double temp2_imp=total(temp_imp)
	g `var'_imp=temp2_imp
	drop temp*
	compare `var' `var'_imp
	}

g dif=bacc-_bacc
sum dif if dif>0, d
sort wave hhid_current mergeid implicat
order wave hhid_current mergeid mergeidp implicat bacc _bacc bacc_f fin_resp fam_resp
browse if abs(dif)>1
drop dif

g dif=bsmf-_bsmf
sum dif if dif>0, d
sort wave hhid_current mergeid implicat
order wave hhid_current mergeid mergeidp implicat bsmf _bsmf bsmf_f fin_resp fam_resp
browse if abs(dif)>1
drop dif

g dif=slti-_slti
sum dif if dif>0, d
sort wave hhid_current mergeid implicat
order wave hhid_current mergeid mergeidp implicat slti _slti slti_f fin_resp fam_resp
browse if abs(dif)>1
drop dif

g dif=liab-_liab
sum dif if dif>0, d
sort wave hhid_current mergeid implicat
order wave hhid_current mergeid mergeidp implicat liab _liab liab_f fin_resp fam_resp
browse if abs(dif)>1
drop dif

foreach var in bacc bsmf slti liab {
	gen double temp=`var' if `var'_f!=1
	gen double temp_imp=`var' if `var'_f>=4 & `var'_f<=11
	bys implicat hhid_current wave: egen double temp2=total(temp)
	bys implicat hhid_current wave: egen double temp2_imp=total(temp_imp)
	replace `var'=temp2
	g `var'_imp=temp2_imp
	g temp_flag=`var'_f>=4 & `var'_f<=11
	egen `var'_FLAG=max(temp_flag), by(implicat hhid_current wave)
	drop temp*
}

foreach var in hrass {
	g temp_flag=`var'_f>=4 & `var'_f<=11
	egen `var'_FLAG=max(temp_flag), by(implicat hhid_current wave)
	drop temp*
}

g Nhnfass=bacc+bsmf+slti-liab
sum Nhnfass hnfass

label var rhre "Hhd annual rent and other rent-related expenditure (monthly value X 12)"
label var rhre_imp "Hhd annual rent and other rent-related expenditure (monthly value X 12)"

label var fahc "Hhd annual expenditure on food at home (monthly value X 12)"
label var fahc_imp "Hhd annual expenditure on food at home (monthly value X 12)"

label var fohc "Hhd annual expenditure on food outside the home (monthly value X 12)"
label var fohc_imp "Hhd annual expenditure on food outside the home (monthly value X 12)"

label var bacc "Hhd bank accounts"
label var bacc_imp "Hhd bank accounts"

label var bsmf "Hhd gross financial assets (only bonds, stocks and mutual funds)"
label var bsmf_imp "Hhd gross financial assets (only bonds, stocks and mutual funds)"

label var slti "Hhd savings for long-term investments"
label var slti_imp "Hhd savings for long-term investments"

label var hnfass "Hhd net financial assets"
g hnfass_impF=bacc_FLAG==1 | bsmf_FLAG==1 | slti_FLAG==1 | liab_FLAG==1 
label var hnfass_imp "Hhd net financial assets"

label var liab "Hhd Financial liabilities"
label var liab_imp "Hhd Financial liabilities"

label var hrass "Hhd real assets"
g hrass_impF=hrass_FLAG==1
label var hrass_impF "Hhd real assets"

label var hnetw "Hhd net worth"
g hnetw_impF=bacc_FLAG==1 | bsmf_FLAG==1 | slti_FLAG==1 | liab_FLAG==1 | hrass_impF==1
label var hnetw_impF "Hhd net worth (flag)"

ren thinc hy
label var hy "Hhd net income"
ren thinc_imp hy_imp
label var hy_imp "Hhd net income"

g ydip_imp=0
tab ydip_f
replace ydip_imp=ydip if ydip_f>=4 & ydip_f<=11
label var ydip "Annual individual income from employment previous year"
label var ydip_imp "Annual individual income from employment previous year"

ren yind yself
tab yind_f
g yself_imp=0
replace yself_imp=yself if yind_f>=4 & yind_f<=11
label var yself "Annual individual income from self-employment previous year"
label var yself_imp "Annual individual income from self-employment previous year"

sum ydip ydip_imp yself yself_imp rhre rhre_imp fahc fahc_imp fohc fohc_imp bacc bacc_imp bsmf bsmf_imp ///
	slti slti_imp hnfass hnfass_impF liab liab_imp hrass hrass_impF hnetw hnetw_impF hy hy_imp mergeid wave country ppp* nomx*
	
keep  hhid_current ydip ydip_imp yself yself_imp rhre rhre_imp fahc fahc_imp fohc fohc_imp bacc bacc_imp bsmf bsmf_imp ///
	slti slti_imp hnfass hnfass_impF liab liab_imp hrass hrass_impF hnetw hnetw_impF hy hy_imp mergeid wave country ppp* nomx*

collapse (mean) ydip ydip_imp yself yself_imp rhre rhre_imp fahc fahc_imp bacc bacc_imp fohc fohc_imp bsmf bsmf_imp ///
	slti slti_imp hnfass hnfass_impF liab liab_imp hrass hrass_impF hnetw hnetw_impF hy hy_imp ppp* nomx* ///
		, by(hhid_current mergeid wave country)

sort mergeid wave 
merge 1:1 mergeid wave using interview_year
tab wave _merge
drop _merge

forvalues aa=2004(1)2015 {
	di "********`aa'**********"
	count if int_year==`aa'
	local aaa=`aa'-1
	sum nomx`aaa' if int_year==`aa'
	sum nomx`aa' if int_year==`aa'
	}
tab country if int_year==2006 & nomx2006==.
* Israel is not an issue, we don't use it
* Only Belgium is an issue
sum nomx2006 if country==23
replace nomx2006=1 if country==23 & nomx2006==. & int_year==2006
tab country if int_year==2010 & nomx2009==.
* Estonia is not an issue, we don't use it

forvalues aa=2004(1)2015 {
	di "********`aa'**********"
	count if int_year==`aa'
	local aaa=`aa'-1
	sum pppx`aaa' if int_year==`aa'
	sum pppx`aa' if int_year==`aa'
	}
sum pppx2006 if country==23
replace pppx2006=1.02742 if country==23 & pppx2006==. & int_year==2006
	
foreach var in bacc bacc_imp bsmf bsmf_imp ///
	slti slti_imp hnfass liab liab_imp hrass hnetw {
	forvalues aa=2004(1)2015 {
	replace `var'=`var'*nomx`aa'/pppx`aa' if int_year==`aa'
	}
}

foreach var in ydip ydip_imp yself yself_imp rhre rhre_imp fahc fahc_imp fohc fohc_imp hy hy_imp {
	forvalues aa=2003(1)2014 {
	replace `var'=`var'*nomx`aa'/pppx`aa' if int_year==`aa'+1
	}
}

tab country wave if hnetw==.
tab country wave if hy==.

sort country mergeid wave
save income_wealth_consumption, replace

*************************************************************************************************
* AC
use "$root/Wave 4/sharew4_rel6-0-0_ac.dta", clear
g wave=4
append using "$root/Wave 5/sharew5_rel6-0-0_ac.dta"
recode wave .=5

sharetom5 _all, replace

g read=ac035d8==1
replace read=. if ac035d8==. | ac035d8==.a | ac035d8==.b

keep country mergeid wave read
sort country mergeid wave
save activities, replace

* IT
use "$root/Wave 5/sharew5_rel6-0-0_it.dta", clear
g wave=5

sharetom5 _all, replace

g internet_5=it004_==1
replace internet_5=. if it004_==. | it004_==.a | it004==.b

keep country mergeid wave internet_5
sort country mergeid wave
save internet_5, replace

*****************************************
capture erase income_imputation_raw.dta
capture erase employment_raw.dta

* FINAL
use cover, clear
drop if interview==0
keep country mergeid wave language
save canc,replace

use demographic, clear
sort country mergeid wave
merge 1:1 country mergeid wave using canc
drop _merge
sort country mergeid wave
merge 1:1 country mergeid wave using expectations
drop _merge
merge 1:1 country mergeid wave using employment
drop _merge
merge 1:1 country mergeid wave using pension_claim
drop _merge
merge 1:1 country mergeid wave using income_wealth_consumption
drop _merge
merge 1:1 country mergeid wave using care_short
drop _merge
merge 1:1 country mergeid wave using transfers_short
drop _merge
merge 1:1 country mergeid wave using activities
drop _merge
merge 1:1 country mergeid wave using internet_5
drop _merge
g internet=internet_4 if wave==4
recode internet 5=0
replace internet=internet_5 if wave==5
replace internet=. if internet==.a | internet==.b
egen max_internet=max(internet), by(country mergeid)

g x=1
egen totwaves=sum(x), by(mergeid)
drop x
label var totwaves "Total no. of waves in which s/he has an interview"
sort country mergeid wave
compress
merge 1:1 country mergeid wave using weights
tab country wave if _merge==1
drop _merge
sort country mergeid wave
saveold complete, replace

/*
* Checks for missing and others
use complete, clear
tab dm_age_years wave, miss
tab dm_education wave, miss
tab dm_education wave, miss nol
tab dm_bornlocal wave, miss
tab dm_citizen wave, miss
tab dm_marstatus wave, miss nol
tab ex_sunny wave, miss
tab ex_sunny wave, miss nofreq col
tab ex_gov_red_pen wave, miss nofreq col
tab ex_gov_red_pen wave if em_employment==2, miss nofreq col
tab ex_gov_red_pen wave if cl_pensiond1==1 | cl_pensiond2==1 | cl_pensiond3==1, miss nofreq col
tab ex_gov_age_incr wave if em_employment==2 & dm_age_years<61, miss nofreq col
tab ex_gov_age_incr wave if em_employment==2 , miss nofreq col
tab ex_gov_age_incr wave if (cl_pensiond1==1 | cl_pensiond2==1 | cl_pensiond3==1), miss nofreq col
tab ex_gov_age_63 wave if em_employment==2 & dm_age_years<61 , miss nofreq col
tab ex_gov_age_63 wave if (cl_pensiond1==1 | cl_pensiond2==1 | cl_pensiond3==1) & dm_age_years<61, miss nofreq col
tab em_employment wave, miss
tab em_employment wave, miss nofreq col
tab em_worked_anyway
tab em_worked_anyway wave
tab em_worked_anyway wave, miss
tab em_worked_anyway wave, miss nol
tab em_mainjob_type wave if em_employment==2 | em_worked_anyway==1, miss
tab em_mainjob_type wave if em_employment==2 | em_worked_anyway==1, miss nofreq col
*/
log close
